C==========================================================
C     PROGRAM CATFISH -- VER. 2.10
C     Purpose: BH generator for LHC
C==========================================================

      PROGRAM CATFISH
      
      IMPLICIT NONE
      LOGICAL YNFLAG,EMCHARGEFLAG
      INTEGER NI,UP,NP,YVER,MOMTRANSF,RSEED,MLIST,IS_OSSF(2)
      INTEGER HARDPARTICLE(18,3),TABLEPARTICLE(1000,3),IARR(5)
      DOUBLEPRECISION S,B,MST,ALPHA,PI,XMIN,ILUM,QMIN
      DOUBLEPRECISION YYN(100),ZYN(100),ECM,DMLL(4)
      
      COMMON/BH_PARAMETERS/MST,ALPHA,XMIN,QMIN,NI,MOMTRANSF
      COMMON/PARAMETERS/PI
      COMMON/YOSHINO/ ZYN,YYN,UP,YVER
      COMMON/FLAGS/YNFLAG,EMCHARGEFLAG
      COMMON/IENERGY/ECM
      

      INTEGER KGENEV
      REAL TECM,AMASS(18),PCM(5,18),WT
 
      COMMON/GENIN / NP, TECM, AMASS, KGENEV
      COMMON/GENOUT/ PCM, WT


      INTEGER TOTMULT,I,J
      INTEGER NUMPARTICLE,NUMEVENTS,XBINS,MRXBINS
      INTEGER TIMEARRAYI(8),TIMEARRAYF(8)
      CHARACTER*8 DATEI,DATEF
      CHARACTER*10 TIMEI,TIMEF
      CHARACTER*5  ZONE
 
      DOUBLEPRECISION REALBMAX,MBINS,VP(1000,6),CUTS(6)
      COMMON/SIMULATION/CUTS,NUMEVENTS,RSEED,MLIST
      COMMON/DATETIME/DATEI,DATEF,TIMEARRAYI,TIMEARRAYF

      EXTERNAL REALBMAX

      COMMON/CODE_PARAMETERS/MBINS,XBINS,MRXBINS


      INTEGER    NEVHEP, NHEP, ISTHEP, IDHEP, JMOHEP, JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      INTEGER    NMXHEP
      PARAMETER (NMXHEP=4000)
      COMMON/HEPEVT/NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &     JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),
     &     PHEP(5,NMXHEP),VHEP(4,NMXHEP)

      REAL RVEC

      DOUBLEPRECISION MBH, TEMPERATURE, LIFETIME
      EXTERNAL MBH, TEMPERATURE, LIFETIME

      INTEGER NJET
      DOUBLEPRECISION SPH,APL,THR,OBL
      DOUBLEPRECISION PMH,PML,H10,H20,H30,H40

      INTEGER MSTU(200),MSTJ(200),MSTP(200),MSTI(200)
      DOUBLEPRECISION PARU(200),PARJ(200),PARP(200),PARI(200)
      
      INTEGER MSEL,MSELPD,MSUB(500),KFIN(2,-40:40)
      DOUBLEPRECISION CKIN(200)    

      COMMON/PYDAT1/MSTU,PARU,MSTJ,PARJ
      COMMON/PYPARS/MSTP,PARP,MSTI,PARI
      COMMON/PYSUBS/MSEL,MSELPD,MSUB,KFIN,CKIN
      SAVE /PYDAT1/,/PYPARS/,/PYSUBS/

 
      INTEGER MAXNUP
      PARAMETER (MAXNUP=500)
      INTEGER NUP,IDPRUP,IDUP,ISTUP,MOTHUP,ICOLUP
      DOUBLE PRECISION XWGTUP,SCALUP,AQEDUP,AQCDUP,PUP,VTIMUP,SPINUP
      COMMON/HEPEUP/NUP,IDPRUP,XWGTUP,SCALUP,AQEDUP,AQCDUP,IDUP(MAXNUP),
     &ISTUP(MAXNUP),MOTHUP(2,MAXNUP),ICOLUP(2,MAXNUP),PUP(5,MAXNUP),
     &VTIMUP(MAXNUP),SPINUP(MAXNUP)
      SAVE /HEPEUP/
            
      INTEGER N,NPAD,K(4000,5)
      DOUBLEPRECISION P(4000,5),V(4000,5)
      COMMON/PYJETS/N,NPAD,K,P,V
      
      INTEGER PYK
      DOUBLEPRECISION ENEVT(11),PTEVT(11),PYP          

      EXTERNAL PYK,PYP
      
      INTEGER BHARRAY(1000),IBH
      DOUBLEPRECISION M
      COMMON/BHMASS/M

      PI=3.141592653589793D0    

      ILUM=1.0D5 ! in picobarn

      MBINS=0.5D0
      XBINS=200
      MRXBINS=50
            
      KGENEV=1      
    
      PARU(58)=10.0 
      PARU(54)=0.2

      CALL DATE_AND_TIME(DATEI,TIMEI,ZONE,TIMEARRAYI)
            
      CALL READGLOBAL()

      ECM=14.0D0

      CALL PYINIT('USER','p','p',ECM*1000.0D0)      

      CALL RLUXGO(4,RSEED,0,0) ! random seed generator
 
      OPEN(UNIT=12,FILE='catfish-v2.10.sphe',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=13,FILE='catfish-v2.10.thru',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=14,FILE='catfish-v2.10.cell',STATUS='UNKNOWN',
     ! ERR=9000)
     
      OPEN(UNIT=15,FILE='catfish-v2.10.jmas',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=16,FILE='catfish-v2.10.fowo',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=17,FILE='catfish-v2.10.energy',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=18,FILE='catfish-v2.10.pt',STATUS='UNKNOWN',
     ! ERR=9000)
     
      OPEN(UNIT=69,FILE='catfish-v2.10.eta',STATUS='UNKNOWN',
     ! ERR=9000)
     
      OPEN(UNIT=96,FILE='catfish-v2.10.phi',STATUS='UNKNOWN',
     ! ERR=9000)

      OPEN(UNIT=71,FILE='catfish-v2.10.mll',STATUS='UNKNOWN',
     ! ERR=9000)
     


      DO I=1,1000
         BHARRAY(I)=0
      ENDDO
      
      M=0.0D0
     
      DO J=1,NUMEVENTS

         
        WRITE(*,*)  '\n#Event: ', J

100     CALL PYEVNT
	
	CALL PYEDIT(1)			
        CALL PYLIST(MLIST)
		
	CALL PYSPHE(SPH,APL)
	
	IF(SPH .NE. -1.0D0 .AND. APL .NE. -1.0D0) THEN
    	  WRITE(12,'(I8,D15.3,D15.3)') J, SPH, APL
	ENDIF


       CALL OSSFDILEPMLL(IARR,DMLL)
       IF(IARR(3) .EQ. 1) WRITE(71,'(I8,D15.3)') J,DMLL(1)
	    		
	CALL PYTHRU(THR,OBL)

	IF(THR .NE. -1.0D0 .AND. THR .NE. -2.0D0 .AND.
     !OBL .NE. -1.0D0 .AND. OBL .NE. -2.0D0) THEN
          WRITE(13,'(I8,D15.3,D15.3)') J, THR, OBL
 	ENDIF

        CALL PYCELL(NJET)

	IF(NJET .NE. -2) THEN
	   WRITE(14,'(I8,I8)') J, NJET
           WRITE(69,'(I8,20(D15.3))') J, (P(N+I,3),I=1,NJET)
	   WRITE(96,'(I8,20(D15.3))') J, (P(N+I,4),I=1,NJET)
	ENDIF
	
	
       CALL PYJMAS(PMH,PML)

	IF(PMH .NE. -2.0D0 .AND.PML .NE. -2.0D0) 
     !WRITE(15,'(I8,D15.3,D15.3)') J, PMH, PML
        		     
         CALL PYFOWO(H10,H20,H30,H40)
    	   WRITE(16,'(I8,D15.3,D15.3,D15.3,D15.3)') J,H10,H20,H30,H40


	  CALL EVTEN(ENEVT,PTEVT)
    	  WRITE(17,'(I8,11(D15.3))') J, (ENEVT(I), I=1,11)
    	  WRITE(18,'(I8,7(D15.3))') J, (PTEVT(I), I=1,7)
	  

	   
	IBH=INT(M*10.0D0+0.5)
        BHARRAY(IBH)=BHARRAY(IBH)+1
	   
      ENDDO    
    
      
      CLOSE(12)
      CLOSE(13)
      CLOSE(14)
      CLOSE(15)
      CLOSE(16)
      CLOSE(17)
      CLOSE(18)
      CLOSE(69)
      CLOSE(71)
      CLOSE(96)



c     CALL PLOTBHMASS(BHARRAY) ! UNCOMMENT THIS FOR LHC MBH PLOT

      CALL DATE_AND_TIME(DATEF,TIMEF,ZONE,TIMEARRAYF)

      CALL WRITESUMMARY()

      RETURN
      
9000  OPEN(UNIT=99,FILE='catfish-v2.10.error',STATUS='UNKNOWN')		
      WRITE(99,*) 'File catfish-v2.10.dat cannot be written'
      CLOSE(99)
      STOP      
 
      END PROGRAM CATFISH
C==========================================================
